#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);

    int n;
    cin >> n;
    vector<long long> x(n), h(n);
    for(int i=0;i<n;i++) cin >> x[i];
    for(int i=0;i<n;i++) cin >> h[i];

    vector<int> order(n);
    iota(order.begin(), order.end(), 0);
    sort(order.begin(), order.end(), [&](int a,int b){ return x[a]<x[b]; });

    vector<int> NGL(n), NGR(n);
    stack<int> st;

    // NGL
    for(int i=0;i<n;i++){
        int idx = order[i];
        while(!st.empty() && h[st.top()] <= h[idx]) st.pop();
        NGL[i] = st.empty() ? -1 : st.top();
        st.push(idx);
    }

    while(!st.empty()) st.pop();

    // NGR
    for(int i=n-1;i>=0;i--){
        int idx = order[i];
        while(!st.empty() && h[st.top()] <= h[idx]) st.pop();
        NGR[i] = st.empty() ? -1 : st.top();
        st.push(idx);
    }

    vector<long long> res(n, -1);
    for(int i=0;i<n;i++){
        int idx = order[i];
        long long d = LLONG_MAX, l = LLONG_MAX;
        if(NGR[i]!=-1) d = (x[NGR[i]] - h[NGR[i]] + h[idx]) - x[idx];
        if(NGL[i]!=-1) l = x[idx] - (x[NGL[i]] + h[NGL[i]] - h[idx]);
        long long val = min(d,l);
        res[idx] = (val >= LLONG_MAX ? -1 : val);
    }

    for(auto v:res) cout << v << "\n";
}